VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cSVGRenderBox"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private SVG As cSVG, LastSvgFileName As String
Private mWidth As Double, mHeight As Double

Private CenterDrag As cControlPoint
Attribute CenterDrag.VB_VarHelpID = -1

Public Sub Init(ControlPoints As cControlPoints, ByVal X As Double, ByVal Y As Double, Optional ByVal Width As Double = 128, Optional ByVal Height As Double = 128)
  Set SVG = New cSVG
  mWidth = Width
  mHeight = Height
  Set CenterDrag = ControlPoints.Add("CenterDrag" & ObjPtr(Me), X, Y, , , 0#)
  CenterDrag.SetRectangularStyle mWidth, mHeight
End Sub

Public Sub Draw(CC As cCairoContext, SVGFileName As String, ByVal NewScale As Double, ByVal NewRotateDeg As Double)
Dim DX As Double, DY As Double

  If LastSvgFileName <> SVGFileName Then 'this ensures, that the Parsing-Part of reading an SVG is done only on FileName-Changes
    LastSvgFileName = SVGFileName
    If Len(SVGFileName) = 0 Then Exit Sub
    
    SVG.ParseContent SVGFileName
  End If

  CC.Save
    'the next three lines handle the correct SVG-Rendering, directly from the SVG-DOM...
    'On complex SVG-Images this is by far not that performant as rendering a (larger) Surface-PixelBitmap (please look into Demo #12, to see what I mean)
    'To render really resolution-independent, the SVG-Class needs to go through each entry in the DOM, performing the required
    'VectorDrawing-Commands (translated into Cairo-Calls of course), layer by layer (SVG-XML usually contains nested SubGroups)
    'To achieve a better performance in a real App-scenario (with SVG-resources), you can (should) pre-render them into a large enough Pixel-Surface
    'that suits your needs - and scale "all the rest" from there (e.g. the Cairo.ImageList supports such PixelSurface-Prerendering with one single call - please look into Demo #15, what is done there for the SVG-Icons)
    '...
    'Nonetheless the performance of the wrappers cSVG-Class (entirely written in VB6, including the Gaussian-Blur) is quite good -
    'please compare that for example on: "gallardo.svg" or on: "juanmontoya-lingerie.svg" which are contained here in this Demo -
    'and then check the same images per Firefox, directly over the weblinks:
    'http://dev.w3.org/SVG/tools/svgweb/samples/svg-files/gallardo.svg
    'http://dev.w3.org/SVG/tools/svgweb/samples/svg-files/juanmontoya_lingerie.svg
    'by trying to resize these images there in your browser per <Ctrl>+MouseWheel and compare the SVG-Re-Rendering-performance with this VB-Demo)
    DX = mWidth * NewScale
    DY = mHeight * NewScale
    SVG.RenderFromDOM CC, CenterDrag.X - DX / 2, CenterDrag.Y - DY / 2, DX, DY, NewRotateDeg
    
    'Ok - the above was the SVG-rendering, "bounded" within a (normally) non-visual rectangular area
    '...
    'So, all the rest below is a simple (somewhat shadowed) Rounded-Rectangle-Outlining, to show you the current SVG-bounding-Rect (we've used in the call above)
    CC.TranslateDrawings -4, -4
    CC.RoundedRect CenterDrag.X - DX / 2, CenterDrag.Y - DY / 2, DX + 8, DY + 8, 5
      CC.SetLineWidth 5
      CC.SetSourceColor vbBlack, 0.1 '<- shadow alpha
    CC.Stroke

    CC.RoundedRect CenterDrag.X - DX / 2, CenterDrag.Y - DY / 2, DX + 8, DY + 8, 3
      CC.SetLineWidth 2
      CC.SetSourceColor vbBlack, 0.4 '<- the "on-top-alpha" of the smaller-linesized-Rect is somewhat higher
    CC.Stroke
  CC.Restore
  
  'finally adapt the (here rectangular and invisible) ControlPoint-Dimensions to the ones of the "SVG-Rectangle")
  CenterDrag.SetRectangularStyle DX, DY
End Sub

